﻿// 自动实现的属性
public class Example
{
    private string name;

    public string Name { get => name; set => name = value; }

    public string Id { get; set; }

    public int Count { get; private set; }

    public string UserId { get;}

    public Example(string userId)
    {
	this.UserId = userId;
    }
}


// 匿名类型
var user = new { name = "Gao", id = 996, height = 172.5 };	// 此时编译器会提示匿名类型， 是 new {string name, int id, double height}
Console.WriteLine(string.Format("name {0}, id {1}, height {2}", user.name, user.id, user.height));

var result = from example in examples select new { example.Name };

foreach (var item in result)
{
	Console.WriteLine(item.Name);
}

// 查询表达式
from example in examples
where example.Count > 10
orderby example.Count descending
select $"{example.Name}\t{example.Count}";

// Lambda 表达式
Func<int, int> square = x => x * x;
Console.WriteLine(square(5));

// 表达式树
Expression<Func<int>> add = () => 1 + 2;
var func = add.Compile(); // 创建一个 delegate
var answer = func(); // 调用 delegate， 得到值3
Console.WriteLine(answer);

// 扩展方法
public static class Extensions
{
    public static bool IsContainQ(this String str)
    {
        foreach (var item in str)
        {
            if (item.Equals('Q') || item.Equals('q'))
            {
                return true;
            }
        }

        return false;
    }
}

// 隐式类型本地变量
// 分部方法
// 对象和集合初始值设定项